<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*//** */
 
require_once 'mailbox_controller.php';

/**
* API methods to manage a mailbox's messages.
*
* Inherits mailbox validation from the mailbox controller.  Mailbox name is a required field for all actions on this controller, with the exception of messages to send or save a messagage; these actions require the sender's email address to be provided.
*
* @author           <bell_adam@bah.com>
* @author M. Gibbs <gibbs_margaret@bah.com>
* @author Elan Jaffee <jaffee_elan@bah.com>
*
* @package direct-as-a-service
* @subpackage controllers
*/
class Message_controller extends Mailbox_controller{	
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();
		$this->load->helper(array('mail', 'validate'));
	}	
				
	/**
	* Archives a message.
	* 
	* This action is not available for inactive mailboxes.
	*
	* @param string mailbox name
	* @param int id of the message
	*/
	public function archive_message_post(){
		//set up the required fields
		$required_fields = array('id');
		$post = $this->post();
        foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $post))
				$$required_field = $this->post($required_field);
			else{
				array_push($this->missing_required_fields, $required_field);
			}
        }
		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();

		if(!Message::formatted_like_an_id($id)){
			$this->invalid_fields[] = 'id';
		}
		$this->respond_with_error_if_fields_are_invalid();	
		
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)){
			$this->response('Message not found.', 422);
		}
		$this->response_message['id'] = $id;
		$message->archive();
		$this->response($this->response_message, 200);
	}
	
	/**
	* Sets the custom flag of the message specified.
	* 
	* This action is not available for inactive mailboxes.
	*	
	* @param string mailbox name
	* @param int id of the message
	* @param int|string id of custom folder or inbox  
	*/	
	public function move_message_post(){
		$required_fields = array('id', 'folder');
		$post = $this->post();
        foreach($required_fields as $required_field){
        if(array_key_exists($required_field, $post))
            $$required_field = $this->post($required_field);
        else{
        	array_push($this->missing_required_fields, $required_field);
           }
        }
		
		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();

		if(!Message::formatted_like_an_id($id)){
			array_push($this->invalid_fields, 'id');
		}
		if($folder !== 'inbox' && !(Folder::formatted_like_an_id($folder) && $this->mailbox->has_related('folder', array('id' =>$folder)))) {
			array_push($this->invalid_fields, 'folder');
		}
		$this->respond_with_error_if_fields_are_invalid();
		
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)){
			$this->response('Message not found.', 422);
		}
		
		if(Folder::formatted_like_an_id($folder)){
			$message->move_to_folder($folder);
		}
		else if($folder === 'inbox'){
			$message->move_to_inbox();
		}
		
		$this->response_message['id'] = $id;
		$this->response_message['folder'] = $folder;
		$this->response($this->response_message, 200);
	}
	
	
	/**
	* Restores a message to its previous folder or folder in designated in the parameter
	* 
	* This action is not available for inactive mailboxes.
	*	
	* @param string mailbox name
	* @param int id of the message
	* @param int|string id of custom folder or inbox  
	*/
	public function restore_message_post(){
		$required_fields = array('id');
		$post = $this->post();
        foreach($required_fields as $required_field){
        if(array_key_exists($required_field, $post))
            $$required_field = $this->post($required_field);
        else{
        	array_push($this->missing_required_fields, $required_field);
           }
        }

		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();
		
		if(!Message::formatted_like_an_id($id)){
			$this->invalid_fields[] = 'id';
		}
		
		$folder_id = element('folder', $post, null);
		if($folder_id !== null && $folder_id !== 'inbox' && !Folder::formatted_like_an_id($folder_id) && !$this->mailbox->has_related('folder', array('id' =>$folder_id))){
			array_push($this->invalid_fields, 'folder');
		}
		
		$this->respond_with_error_if_fields_are_invalid();
		
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)){
			$this->response('Message not found.', 422);
		}
		$this->response_message['id'] = $id;

#TODO - CHECK FOR SUCCESS FOR RESTORE() AND MOVE_TO_FOLDER AND MOVE_TO_INBOX BEFORE RETURNING

		$message->restore();
		
		if(Folder::formatted_like_an_id($folder_id)){
			$message->move_to_folder($folder_id);
		}elseif($folder_id == 'inbox'){
			$message->move_to_inbox();
		}
		
		$this->response($this->response_message, 200);
	}	
	
	/**
	* Sets the custom flag of the message specified
	* 
	* This action is not available for inactive mailboxes
	*	
	* @param string mailbox name
	* @param int id of the message
	* @param string text to set flag
	*/	
	public function set_flag_post(){
		$required_fields = array('id', 'text');
		$post = $this->post();
        foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $post))
				$$required_field = $this->post($required_field);
			else{
				array_push($this->missing_required_fields, $required_field);
           	}
        }
		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();

		if(!Message::formatted_like_an_id($id)){
			$this->invalid_fields[] = 'id';
		}
		$this->respond_with_error_if_fields_are_invalid();
	
		$message = Message::find_one($id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)){
			$this->response('Message not found.', 422);
		}
		$message->flags = $text;
		$message->save();
		$this->response_message['id'] = $id;
		$this->response_message['text'] = $text;
		$this->response($this->response_message, 200);
	}
		
}
?>